package gov.va.med.mhv.integration.phr.transfer;

import java.io.Serializable;

/**
 * Immutable class that represents a patient identifier. Includes a utility method for determining if the 
 * instance is an ICN or not.
 * 
 * Author: Barry Egbert
 */
public class PatientIdentifier implements Serializable {

    private static final long serialVersionUID = 2508116242192784725L;
    
    private String identifier = null;
    
    private String assigningFacility = null;
    
    private String assigningAuthority = null;
    
    private String typeCode = null;
    
    public PatientIdentifier(String identifier, String typeCode, String assigningFacility, String assigningAuthority) {
    	this.identifier = identifier;
    	this.typeCode = typeCode;
    	this.assigningFacility = assigningFacility;
    	this.assigningAuthority = assigningAuthority;
    }

    public String getIdentifier() {
		return identifier;
	}
    
    public String getTypeCode() {
		return typeCode;
	}
    
    public String getAssigningAuthority() {
		return assigningAuthority;
	}
    
    public String getAssigningFacility() {
		return assigningFacility;
	}
    
    public boolean isIcn() {
    	return "NI".equals(this.typeCode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PatientIdentifier that = (PatientIdentifier) o;
        if (identifier != null ? !identifier.equals(that.identifier) : that.identifier != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result;
        result = (identifier != null ? identifier.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PatientIdentifier{" +
                "icn='" + identifier + '\'' +
                '}';
    }
}
